<?php
/**
 * Expert Betting Insights Block ACF Fields
 */

if (!function_exists('acf_add_local_field_group')) {
    return;
}

acf_add_local_field_group([
    'key' => 'group_expert_betting_insights',
    'title' => 'Expert Betting Insights Configuration',
    'fields' => [
        [
            'key' => 'field_title',
            'label' => 'Title',
            'name' => 'title',
            'type' => 'text',
            'required' => 1,
            'placeholder' => 'e.g., Expert Betting Insights',
            'default_value' => 'Expert Betting Insights',
        ],
        [
            'key' => 'field_insights_repeater',
            'label' => 'Betting Insights',
            'name' => 'insights',
            'type' => 'repeater',
            'layout' => 'block',
            'required' => 1,
            'min' => 1,
            'max' => 5,
            'button_label' => 'Add Insight',
            'sub_fields' => [
                [
                    'key' => 'field_insight_question',
                    'label' => 'Question',
                    'name' => 'question',
                    'type' => 'text',
                    'required' => 1,
                    'placeholder' => 'e.g., What is the Falcons\' ATS record on the road?',
                ],
                [
                    'key' => 'field_insight_answer',
                    'label' => 'Answer',
                    'name' => 'answer',
                    'type' => 'textarea',
                    'required' => 1,
                    'rows' => 3,
                    'placeholder' => 'e.g., Falcons are 5-1 ATS in their last 6 road games, showing strong value as underdogs away from home.',
                ],
            ],
        ],
        [
            'key' => 'field_button_link',
            'label' => 'Button Link',
            'name' => 'button_link',
            'type' => 'link',
            'required' => 0,
            'return_format' => 'array',
            'instructions' => 'Set the button text and URL. Leave empty to hide the button.',
        ],
        [
            'key' => 'field_background_color',
            'label' => 'Background Color',
            'name' => 'background_color',
            'type' => 'color_picker',
            'required' => 0,
            'default_value' => '#2c3e50',
            'instructions' => 'Main background color for the block.',
        ],
        [
            'key' => 'field_card_background_color',
            'label' => 'Card Background Color',
            'name' => 'card_background_color',
            'type' => 'color_picker',
            'required' => 0,
            'default_value' => '#1a1a1a',
            'instructions' => 'Background color for the insight cards.',
        ],
        [
            'key' => 'field_text_color',
            'label' => 'Text Color',
            'name' => 'text_color',
            'type' => 'color_picker',
            'required' => 0,
            'default_value' => '#ffffff',
            'instructions' => 'Text color for the block content.',
        ],
        [
            'key' => 'field_border_left_color',
            'label' => 'Border Left Color',
            'name' => 'border_left_color',
            'type' => 'color_picker',
            'required' => 0,
            'default_value' => '#3F4A53',
            'instructions' => 'Color for the left border of the block.',
        ],
        [
            'key' => 'field_question_icon_color',
            'label' => 'Question Icon Color',
            'name' => 'question_icon_color',
            'type' => 'color_picker',
            'required' => 0,
            'default_value' => '#32cd32',
            'instructions' => 'Background color for the question mark icons.',
        ],
        [
            'key' => 'field_show_header_icon',
            'label' => 'Show Header Icon',
            'name' => 'show_header_icon',
            'type' => 'true_false',
            'required' => 0,
            'default_value' => 1,
            'ui' => 1,
            'instructions' => 'Show or hide the icon in the header section.',
        ],
        [
            'key' => 'field_custom_header_icon_svg',
            'label' => 'Custom Header Icon SVG',
            'name' => 'custom_header_icon_svg',
            'type' => 'textarea',
            'required' => 0,
            'rows' => 4,
            'placeholder' => 'Paste your custom SVG code here...',
            'instructions' => 'Custom SVG code for the header icon. Leave empty to use default icon.',
        ],
        [
            'key' => 'field_show_question_icons',
            'label' => 'Show Question Icons',
            'name' => 'show_question_icons',
            'type' => 'true_false',
            'required' => 0,
            'default_value' => 1,
            'ui' => 1,
            'instructions' => 'Show or hide the question mark icons in each insight card.',
        ],
        [
            'key' => 'field_custom_question_icon_svg',
            'label' => 'Custom Question Icon SVG',
            'name' => 'custom_question_icon_svg',
            'type' => 'textarea',
            'required' => 0,
            'rows' => 4,
            'placeholder' => 'Paste your custom SVG code here...',
            'instructions' => 'Custom SVG code for the question icons. Leave empty to use default question mark.',
        ],
    ],
    'location' => [
        [
            [
                'param' => 'block',
                'operator' => '==',
                'value' => 'acf/expert-betting-insights',
            ],
        ],
    ],
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => 'Configure the Expert Betting Insights block with Q&A format insights and call-to-action.',
]);
