<?php
// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Get field values
$title = $fields['title'] ?? 'Expert Betting Insights';
$insights = $fields['insights'] ?? [];
$button_link = $fields['button_link'] ?? [];
$button_text = $button_link['title'] ?? 'Get More Trends - Free Signup';
$button_url = $button_link['url'] ?? '#';
$button_target = $button_link['target'] ?? '_self';
$background_color = $fields['background_color'] ?? '#2c3e50';
$card_background_color = $fields['card_background_color'] ?? '#1a1a1a';
$text_color = $fields['text_color'] ?? '#ffffff';
$border_left_color = $fields['border_left_color'] ?? '#3F4A53';
$question_icon_color = $fields['question_icon_color'] ?? '#32cd32';
$show_header_icon = $fields['show_header_icon'] ?? true;
$custom_header_icon_svg = $fields['custom_header_icon_svg'] ?? '';
$show_question_icons = $fields['show_question_icons'] ?? true;
$custom_question_icon_svg = $fields['custom_question_icon_svg'] ?? '';

// Set CSS custom properties
$css_vars = [
    '--insights-bg-color' => $background_color,
    '--insights-card-bg-color' => $card_background_color,
    '--insights-text-color' => $text_color,
    '--insights-border-left-color' => $border_left_color,
    '--insights-question-icon-color' => $question_icon_color,
];
$css_vars_string = '';
foreach ($css_vars as $property => $value) {
    $css_vars_string .= $property . ': ' . esc_attr($value) . '; ';
}
?>

<div class="expert-insights" style="<?php echo $css_vars_string; ?>">
    <!-- Header Section -->
    <div class="expert-insights__header">
        <?php if ($show_header_icon): ?>
            <div class="expert-insights__icon">
                <?php if (!empty($custom_header_icon_svg)): ?>
                    <?php echo $custom_header_icon_svg; ?>
                <?php else: ?>
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M3 3V21H21" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M9 9L12 6L16 10L20 6" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                <?php endif; ?>
            </div>
        <?php endif; ?>
        <p class="expert-insights__title"><?php echo esc_html($title); ?></p>
    </div>

    <!-- Insights Cards Section -->
    <div class="expert-insights__content">
        <?php if (have_rows('insights')): ?>
            <?php while (have_rows('insights')): the_row(); ?>
                <?php 
                $question = get_sub_field('question');
                $answer = get_sub_field('answer');
                ?>
                <div class="expert-insights__card">
                    <div class="expert-insights__question">
                        <?php if ($show_question_icons): ?>
                            <div class="expert-insights__question-icon">
                                <?php if (!empty($custom_question_icon_svg)): ?>
                                    <?php echo $custom_question_icon_svg; ?>
                                <?php else: ?>
                                    <span class="expert-insights__question-mark">?</span>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                        <span class="expert-insights__question-text"><?php echo esc_html($question); ?></span>
                    </div>
                    <div class="expert-insights__answer">
                        <?php echo esc_html($answer); ?>
                    </div>
                </div>
            <?php endwhile; ?>
        <?php endif; ?>
    </div>

    <!-- Call-to-Action Button -->
    <?php if (!empty($button_link) && !empty($button_text)): ?>
        <div class="expert-insights__cta">
            <a href="<?php echo esc_url($button_url); ?>" target="<?php echo esc_attr($button_target); ?>" class="expert-insights__button">
                <?php echo esc_html($button_text); ?>
            </a>
        </div>
    <?php endif; ?>
</div>
