<?php
// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Get field values
$game_title = $fields['game_title'] ?? 'Falcons vs Commanders Live Odds';
$subtitle = $fields['subtitle'] ?? 'Shop around for the best lines and maximize your betting value';
$team1_name = $fields['team1_name'] ?? 'Atlanta Falcons';
$team2_name = $fields['team2_name'] ?? 'Washington Commanders';
$active_tab = $fields['active_tab'] ?? 'spread';
$sportsbooks = $fields['sportsbooks'] ?? [];
$footer_message = $fields['footer_message'] ?? 'We track best sports odds daily - Join free to get alerts when lines move in your favor';
?>

<div class="live-odds">
    <!-- Header Section -->
    <div class="live-odds__header">
        <p class="live-odds__title"><?php echo esc_html($game_title); ?></p>
        <?php if ($subtitle): ?>
            <p class="live-odds__subtitle"><?php echo esc_html($subtitle); ?></p>
        <?php endif; ?>
    </div>

    <!-- Navigation Tabs -->
    <div class="live-odds__tabs">
        <button class="live-odds__tab <?php echo $active_tab === 'spread' ? 'live-odds__tab--active' : ''; ?>" data-tab="spread">
            Spread
        </button>
        <button class="live-odds__tab <?php echo $active_tab === 'moneyline' ? 'live-odds__tab--active' : ''; ?>" data-tab="moneyline">
            Moneyline
        </button>
        <button class="live-odds__tab <?php echo $active_tab === 'total' ? 'live-odds__tab--active' : ''; ?>" data-tab="total">
            Total
        </button>
    </div>

    <!-- Odds Table -->
    <div class="live-odds__table-container">
        <div class="live-odds__table">
            <!-- Header Row -->
            <div class="live-odds__header-row">
                <div class="live-odds__header-cell">Sportsbook</div>
                <div class="live-odds__header-cell"><?php echo esc_html($team1_name); ?></div>
                <div class="live-odds__header-cell"><?php echo esc_html($team2_name); ?></div>
            </div>
            
            <!-- Data Rows -->
            <?php if (have_rows('sportsbooks')): ?>
                <?php while (have_rows('sportsbooks')): the_row(); ?>
                    <?php 
                    $sportsbook_name = get_sub_field('name');
                    $spread_odds = get_sub_field('spread_odds');
                    $moneyline_odds = get_sub_field('moneyline_odds');
                    $total_odds = get_sub_field('total_odds');
                    ?>
                    <div class="live-odds__row">
                        <div class="live-odds__sportsbook"><?php echo esc_html($sportsbook_name); ?></div>
                        <div class="live-odds__cell">
                            <span class="live-odds__odds" data-tab="spread"><?php echo esc_html($spread_odds['team1'] ?? ''); ?></span>
                            <span class="live-odds__odds" data-tab="moneyline" style="display: none;"><?php echo esc_html($moneyline_odds['team1'] ?? ''); ?></span>
                            <span class="live-odds__odds" data-tab="total" style="display: none;"><?php echo esc_html($total_odds['over'] ?? ''); ?></span>
                        </div>
                        <div class="live-odds__cell">
                            <span class="live-odds__odds" data-tab="spread"><?php echo esc_html($spread_odds['team2'] ?? ''); ?></span>
                            <span class="live-odds__odds" data-tab="moneyline" style="display: none;"><?php echo esc_html($moneyline_odds['team2'] ?? ''); ?></span>
                            <span class="live-odds__odds" data-tab="total" style="display: none;"><?php echo esc_html($total_odds['under'] ?? ''); ?></span>
                        </div>
                    </div>
                <?php endwhile; ?>
            <?php endif; ?>
        </div>
    </div>

    <!-- Footer Section -->
    <?php if ($footer_message): ?>
        <div class="live-odds__footer">
            <p class="live-odds__footer-text"><?php echo esc_html($footer_message); ?></p>
        </div>
    <?php endif; ?>
</div>
