<?php
// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Get field values
$main_headline = $fields['main_headline'] ?? 'Stay Updated - Subscribe to Our Newsletter';
$sub_headline = $fields['sub_headline'] ?? 'Join thousands of subscribers and get the latest updates delivered to your inbox';
$email_placeholder = $fields['email_placeholder'] ?? 'Enter your email address';
$button_text = $fields['button_text'] ?? 'Subscribe Now';
$features = $fields['features'] ?? [];
$privacy_text = $fields['privacy_text'] ?? 'No spam. Unsubscribe anytime. We respect your privacy.';
$form_action = get_option('smarter_blocks_newsletter_cta_form_action', '#');
$form_method = get_option('smarter_blocks_newsletter_cta_form_method', 'post');
$background_color = $fields['background_color'] ?? '#1a1a1a';
$text_color = $fields['text_color'] ?? '#ffffff';
$checkmark_color = $fields['checkmark_color'] ?? '#32cd32';
$show_icon = $fields['show_icon'] ?? true;
$custom_icon_svg = $fields['custom_icon_svg'] ?? '';

// Set CSS custom properties
$css_vars = [
    '--newsletter-bg-color' => $background_color,
    '--newsletter-text-color' => $text_color,
    '--newsletter-checkmark-color' => $checkmark_color,
];
$css_vars_string = '';
foreach ($css_vars as $property => $value) {
    $css_vars_string .= $property . ': ' . esc_attr($value) . '; ';
}
?>

<div class="newsletter-cta" style="<?php echo $css_vars_string; ?>">
    <!-- Header Section -->
    <div class="newsletter__header">
        <div class="newsletter__headline">
            <?php if ($show_icon): ?>
                <div class="newsletter__icon">
                    <?php if (!empty($custom_icon_svg)): ?>
                        <?php echo $custom_icon_svg; ?>
                    <?php else: ?>
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M8.5 14.5A2.5 2.5 0 0 0 11 12c0-1.38-.5-2-1-3-1.072-2.143-.224-4.054 2-6 .5 2.5 2 4.9 4 6.5 2 1.6 3 3.5 3 5.5a7 7 0 1 1-14 0c0-1.153.433-2.294 1-3a2.5 2.5 0 0 0 2.5 2.5z" fill="currentColor"/>
                        </svg>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
            <p class="newsletter__title"><?php echo esc_html($main_headline); ?></p>
        </div>
        <?php if ($sub_headline): ?>
            <p class="newsletter__subtitle"><?php echo esc_html($sub_headline); ?></p>
        <?php endif; ?>
    </div>

    <!-- Newsletter Form Section -->
    <div class="newsletter__form">
        <form class="newsletter__form-element" action="<?php echo esc_url($form_action); ?>" method="<?php echo esc_attr($form_method); ?>">
            <div class="newsletter__input-group">
                <input 
                    type="email" 
                    name="email" 
                    class="newsletter__input" 
                    placeholder="<?php echo esc_attr($email_placeholder); ?>"
                    required
                >
                <button type="submit" class="newsletter__button">
                    <?php echo esc_html($button_text); ?>
                </button>
            </div>
        </form>
    </div>

    <!-- Features List Section -->
    <?php if (!empty($features)): ?>
        <div class="newsletter__features">
            <ul class="newsletter__features-list">
                <?php if (have_rows('features')): ?>
                    <?php while (have_rows('features')): the_row(); ?>
                        <?php $feature_text = get_sub_field('text'); ?>
                        <li class="newsletter__feature">
                            <div class="newsletter__checkmark">
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M20 6L9 17L4 12" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
                            </div>
                            <span class="newsletter__feature-text"><?php echo esc_html($feature_text); ?></span>
                        </li>
                    <?php endwhile; ?>
                <?php endif; ?>
            </ul>
        </div>
    <?php endif; ?>

    <!-- Privacy Notice Section -->
    <?php if ($privacy_text): ?>
        <div class="newsletter__privacy">
            <p class="newsletter__privacy-text"><?php echo esc_html($privacy_text); ?></p>
        </div>
    <?php endif; ?>
</div>