<?php
/**
 * Sports Stats Display Block ACF Fields
 */

if (!function_exists('acf_add_local_field_group')) {
    return;
}

acf_add_local_field_group([
    'key' => 'group_sports_stats_display',
    'title' => 'Sports Stats Display Configuration',
    'fields' => [
        [
            'key' => 'field_background_color',
            'label' => 'Background Color',
            'name' => 'background_color',
            'type' => 'color_picker',
            'default_value' => '#1a1a1a',
            'wrapper' => [
                'width' => '33',
            ],
        ],
        [
            'key' => 'field_card_background',
            'label' => 'Card Background',
            'name' => 'card_background',
            'type' => 'color_picker',
            'default_value' => '#ffffff',
            'wrapper' => [
                'width' => '33',
            ],
        ],
        [
            'key' => 'field_link_color',
            'label' => 'Link Color',
            'name' => 'link_color',
            'type' => 'color_picker',
            'default_value' => '#007bff',
            'wrapper' => [
                'width' => '33',
            ],
        ],
        [
            'key' => 'field_show_stats_card',
            'label' => 'Show Stats Card',
            'name' => 'show_stats_card',
            'type' => 'true_false',
            'default_value' => 1,
            'ui' => 1,
            'wrapper' => [
                'width' => '33',
            ],
        ],
        [
            'key' => 'field_show_injuries_card',
            'label' => 'Show Injuries Card',
            'name' => 'show_injuries_card',
            'type' => 'true_false',
            'default_value' => 1,
            'ui' => 1,
            'wrapper' => [
                'width' => '33',
            ],
        ],
        [
            'key' => 'field_show_trends_card',
            'label' => 'Show Trends Card',
            'name' => 'show_trends_card',
            'type' => 'true_false',
            'default_value' => 1,
            'ui' => 1,
            'wrapper' => [
                'width' => '33',
            ],
        ],
        // Stats Card
        [
            'key' => 'field_stats_card',
            'label' => 'Stats Card',
            'name' => 'stats_card',
            'type' => 'group',
            'layout' => 'block',
            'conditional_logic' => [
                [
                    [
                        'field' => 'field_show_stats_card',
                        'operator' => '==',
                        'value' => '1',
                    ],
                ],
            ],
            'sub_fields' => [
                [
                    'key' => 'field_stats_title',
                    'label' => 'Card Title',
                    'name' => 'title',
                    'type' => 'text',
                    'default_value' => 'Falcons Record & ATS Stats',
                    'wrapper' => [
                        'width' => '100',
                    ],
                ],
                [
                    'key' => 'field_stats_icon',
                    'label' => 'Card Icon (SVG)',
                    'name' => 'icon',
                    'type' => 'textarea',
                    'placeholder' => 'Paste SVG icon code here',
                    'instructions' => 'Leave empty to hide the icon',
                    'wrapper' => [
                        'width' => '100',
                    ],
                ],
                [
                    'key' => 'field_stats_stats',
                    'label' => 'Statistics',
                    'name' => 'stats',
                    'type' => 'repeater',
                    'layout' => 'block',
                    'button_label' => 'Add Stat',
                    'min' => 1,
                    'sub_fields' => [
                        [
                            'key' => 'field_stat_label',
                            'label' => 'Label',
                            'name' => 'label',
                            'type' => 'text',
                            'required' => 1,
                            'placeholder' => 'e.g., Atlanta SU/ATS:',
                            'wrapper' => [
                                'width' => '100',
                            ],
                        ],
                        [
                            'key' => 'field_stat_value',
                            'label' => 'Value',
                            'name' => 'value',
                            'type' => 'text',
                            'required' => 1,
                            'placeholder' => 'e.g., 2-1 / 1-2',
                            'wrapper' => [
                                'width' => '100',
                            ],
                        ],
                    ],
                ],
                [
                    'key' => 'field_stats_footer_link',
                    'label' => 'Footer Link',
                    'name' => 'footer_link',
                    'type' => 'link',
                    'return_format' => 'array',
                    'wrapper' => [
                        'width' => '100',
                    ],
                ],
            ],
        ],
        // Injuries Card
        [
            'key' => 'field_injuries_card',
            'label' => 'Injuries Card',
            'name' => 'injuries_card',
            'type' => 'group',
            'layout' => 'block',
            'conditional_logic' => [
                [
                    [
                        'field' => 'field_show_injuries_card',
                        'operator' => '==',
                        'value' => '1',
                    ],
                ],
            ],
            'sub_fields' => [
                [
                    'key' => 'field_injuries_title',
                    'label' => 'Card Title',
                    'name' => 'title',
                    'type' => 'text',
                    'default_value' => 'Commanders Key Injuries',
                    'wrapper' => [
                        'width' => '100',
                    ],
                ],
                [
                    'key' => 'field_injuries_icon',
                    'label' => 'Card Icon (SVG)',
                    'name' => 'icon',
                    'type' => 'textarea',
                    'placeholder' => 'Paste SVG icon code here',
                    'instructions' => 'Leave empty to hide the icon',
                    'wrapper' => [
                        'width' => '100',
                    ],
                ],
                [
                    'key' => 'field_injuries_teams',
                    'label' => 'Team Injuries',
                    'name' => 'teams',
                    'type' => 'repeater',
                    'layout' => 'block',
                    'button_label' => 'Add Team',
                    'min' => 1,
                    'sub_fields' => [
                        [
                            'key' => 'field_team_name',
                            'label' => 'Team Name',
                            'name' => 'team_name',
                            'type' => 'text',
                            'required' => 1,
                            'placeholder' => 'e.g., Atlanta Falcons',
                            'wrapper' => [
                                'width' => '100',
                            ],
                        ],
                        [
                            'key' => 'field_team_players',
                            'label' => 'Players',
                            'name' => 'players',
                            'type' => 'repeater',
                            'layout' => 'block',
                            'button_label' => 'Add Player',
                            'sub_fields' => [
                                [
                                    'key' => 'field_player_info',
                                    'label' => 'Player Info',
                                    'name' => 'player_info',
                                    'type' => 'text',
                                    'required' => 1,
                                    'placeholder' => 'e.g., RB Bijan Robinson (Questionable - Hamstring)',
                                    'wrapper' => [
                                        'width' => '100',
                                    ],
                                ],
                            ],
                        ],
                    ],
                ],
                [
                    'key' => 'field_injuries_footer_link',
                    'label' => 'Footer Link',
                    'name' => 'footer_link',
                    'type' => 'link',
                    'return_format' => 'array',
                    'wrapper' => [
                        'width' => '100',
                    ],
                ],
            ],
        ],
        // Trends Card
        [
            'key' => 'field_trends_card',
            'label' => 'Trends Card',
            'name' => 'trends_card',
            'type' => 'group',
            'layout' => 'block',
            'conditional_logic' => [
                [
                    [
                        'field' => 'field_show_trends_card',
                        'operator' => '==',
                        'value' => '1',
                    ],
                ],
            ],
            'sub_fields' => [
                [
                    'key' => 'field_trends_title',
                    'label' => 'Card Title',
                    'name' => 'title',
                    'type' => 'text',
                    'default_value' => 'Betting Trends',
                    'wrapper' => [
                        'width' => '100',
                    ],
                ],
                [
                    'key' => 'field_trends_icon',
                    'label' => 'Card Icon (SVG)',
                    'name' => 'icon',
                    'type' => 'textarea',
                    'placeholder' => 'Paste SVG icon code here',
                    'instructions' => 'Leave empty to hide the icon',
                    'wrapper' => [
                        'width' => '100',
                    ],
                ],
                [
                    'key' => 'field_trends_trends',
                    'label' => 'Betting Trends',
                    'name' => 'trends',
                    'type' => 'repeater',
                    'layout' => 'block',
                    'button_label' => 'Add Trend',
                    'min' => 1,
                    'sub_fields' => [
                        [
                            'key' => 'field_trend_label',
                            'label' => 'Trend Label',
                            'name' => 'label',
                            'type' => 'text',
                            'required' => 1,
                            'placeholder' => 'e.g., ATL as road underdog:',
                            'wrapper' => [
                                'width' => '100',
                            ],
                        ],
                        [
                            'key' => 'field_trend_value',
                            'label' => 'Trend Value',
                            'name' => 'value',
                            'type' => 'text',
                            'required' => 1,
                            'placeholder' => 'e.g., 1-1 ATS',
                            'wrapper' => [
                                'width' => '100',
                            ],
                        ],
                    ],
                ],
                [
                    'key' => 'field_trends_footer_link',
                    'label' => 'Footer Link',
                    'name' => 'footer_link',
                    'type' => 'link',
                    'return_format' => 'array',
                    'wrapper' => [
                        'width' => '100',
                    ],
                ],
            ],
        ],
    ],
    'location' => [
        [
            [
                'param' => 'block',
                'operator' => '==',
                'value' => 'acf/sports-stats-display',
            ],
        ],
    ],
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => 'Configure sports statistics cards with team records, injuries, and betting trends.',
]);