<?php
// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Get field values
$background_color = $fields['background_color'] ?? '#1a1a1a';
$card_background = $fields['card_background'] ?? '#ffffff';
$link_color = $fields['link_color'] ?? '#007bff';

// Show/hide toggles
$show_stats_card = $fields['show_stats_card'] ?? true;
$show_injuries_card = $fields['show_injuries_card'] ?? true;
$show_trends_card = $fields['show_trends_card'] ?? true;

// Card data
$stats_card = $fields['stats_card'] ?? [];
$injuries_card = $fields['injuries_card'] ?? [];
$trends_card = $fields['trends_card'] ?? [];

// Calculate grid columns based on visible cards
$visible_cards = 0;
if ($show_stats_card) $visible_cards++;
if ($show_injuries_card) $visible_cards++;
if ($show_trends_card) $visible_cards++;

$grid_columns = $visible_cards;

// Set CSS custom properties
$css_vars = [
    '--sports-stats-bg-color' => $background_color,
    '--sports-stats-card-bg' => $card_background,
    '--sports-stats-link-color' => $link_color,
    '--sports-stats-grid-columns' => $grid_columns,
];
$css_vars_string = '';
foreach ($css_vars as $property => $value) {
    $css_vars_string .= $property . ': ' . esc_attr($value) . '; ';
}
?>

<div class="sports-stats-display" style="<?php echo $css_vars_string; ?>">
    <div class="sports-stats-display__grid">
        <?php if ($show_stats_card && !empty($stats_card)): ?>
            <div class="sports-stats-display__card">
                <!-- Stats Card Header -->
                <div class="sports-stats-display__header">
                    <?php if (!empty($stats_card['icon'])): ?>
                        <div class="sports-stats-display__icon">
                            <?php echo $stats_card['icon']; ?>
                        </div>
                    <?php endif; ?>
                    <h3 class="sports-stats-display__title"><?php echo esc_html($stats_card['title'] ?? ''); ?></h3>
                </div>

                <!-- Stats Card Content -->
                <div class="sports-stats-display__content">
                    <?php if (!empty($stats_card['stats'])): ?>
                        <?php foreach ($stats_card['stats'] as $stat): ?>
                            <div class="sports-stats-display__stat">
                                <span class="sports-stats-display__stat-label"><?php echo esc_html($stat['label'] ?? ''); ?></span>
                                <span class="sports-stats-display__stat-value"><?php echo esc_html($stat['value'] ?? ''); ?></span>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>

                <!-- Stats Card Footer -->
                <?php if (!empty($stats_card['footer_link']) && !empty($stats_card['footer_link']['url'])): ?>
                    <div class="sports-stats-display__footer">
                        <div class="sports-stats-display__divider"></div>
                        <a href="<?php echo esc_url($stats_card['footer_link']['url']); ?>" 
                           target="<?php echo esc_attr($stats_card['footer_link']['target'] ?? '_self'); ?>" 
                           class="sports-stats-display__footer-link">
                            <span class="sports-stats-display__footer-text"><?php echo esc_html($stats_card['footer_link']['title'] ?? ''); ?></span>
                                <span class="sports-stats-display__footer-arrow">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="11" height="9" viewBox="0 0 11 9" fill="none"><path d="M0.299988 4.30005H10.3M10.3 4.30005L6.13332 0.300049M10.3 4.30005L6.13332 8.30005" stroke="#275FA6" stroke-width="0.6" stroke-linecap="round" stroke-linejoin="round"/></svg>
                                </span>
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <?php if ($show_injuries_card && !empty($injuries_card)): ?>
            <div class="sports-stats-display__card">
                <!-- Injuries Card Header -->
                <div class="sports-stats-display__header">
                    <?php if (!empty($injuries_card['icon'])): ?>
                        <div class="sports-stats-display__icon">
                            <?php echo $injuries_card['icon']; ?>
                        </div>
                    <?php endif; ?>
                    <h3 class="sports-stats-display__title"><?php echo esc_html($injuries_card['title'] ?? ''); ?></h3>
                </div>

                <!-- Injuries Card Content -->
                <div class="sports-stats-display__content">
                    <?php if (!empty($injuries_card['teams'])): ?>
                        <?php foreach ($injuries_card['teams'] as $team): ?>
                            <div class="sports-stats-display__team-injuries">
                                <div class="sports-stats-display__team-name"><?php echo esc_html($team['team_name'] ?? ''); ?></div>
                                <?php if (!empty($team['players'])): ?>
                                    <ul class="sports-stats-display__injuries-list">
                                        <?php foreach ($team['players'] as $player): ?>
                                            <li class="sports-stats-display__injury">
                                                <?php echo esc_html($player['player_info'] ?? ''); ?>
                                            </li>
                                        <?php endforeach; ?>
                                    </ul>
                                <?php endif; ?>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>

                <!-- Injuries Card Footer -->
                <?php if (!empty($injuries_card['footer_link']) && !empty($injuries_card['footer_link']['url'])): ?>
                    <div class="sports-stats-display__footer">
                        <div class="sports-stats-display__divider"></div>
                        <a href="<?php echo esc_url($injuries_card['footer_link']['url']); ?>" 
                           target="<?php echo esc_attr($injuries_card['footer_link']['target'] ?? '_self'); ?>" 
                           class="sports-stats-display__footer-link">
                            <span class="sports-stats-display__footer-text"><?php echo esc_html($injuries_card['footer_link']['title'] ?? ''); ?></span>
                            <span class="sports-stats-display__footer-arrow">
                              <svg xmlns="http://www.w3.org/2000/svg" width="11" height="9" viewBox="0 0 11 9" fill="none"><path d="M0.299988 4.30005H10.3M10.3 4.30005L6.13332 0.300049M10.3 4.30005L6.13332 8.30005" stroke="#275FA6" stroke-width="0.6" stroke-linecap="round" stroke-linejoin="round"/></svg>
                            </span>
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <?php if ($show_trends_card && !empty($trends_card)): ?>
            <div class="sports-stats-display__card">
                <!-- Trends Card Header -->
                <div class="sports-stats-display__header">
                    <?php if (!empty($trends_card['icon'])): ?>
                        <div class="sports-stats-display__icon">
                            <?php echo $trends_card['icon']; ?>
                        </div>
                    <?php endif; ?>
                    <h3 class="sports-stats-display__title"><?php echo esc_html($trends_card['title'] ?? ''); ?></h3>
                </div>

                <!-- Trends Card Content -->
                <div class="sports-stats-display__content">
                    <?php if (!empty($trends_card['trends'])): ?>
                        <?php foreach ($trends_card['trends'] as $trend): ?>
                            <div class="sports-stats-display__stat">
                                <span class="sports-stats-display__stat-label"><?php echo esc_html($trend['label'] ?? ''); ?></span>
                                <span class="sports-stats-display__stat-value"><?php echo esc_html($trend['value'] ?? ''); ?></span>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>

                <!-- Trends Card Footer -->
                <?php if (!empty($trends_card['footer_link']) && !empty($trends_card['footer_link']['url'])): ?>
                    <div class="sports-stats-display__footer">
                        <div class="sports-stats-display__divider"></div>
                        <a href="<?php echo esc_url($trends_card['footer_link']['url']); ?>" 
                           target="<?php echo esc_attr($trends_card['footer_link']['target'] ?? '_self'); ?>" 
                           class="sports-stats-display__footer-link">
                            <span class="sports-stats-display__footer-text"><?php echo esc_html($trends_card['footer_link']['title'] ?? ''); ?></span>
                            <span class="sports-stats-display__footer-arrow">
                                <svg xmlns="http://www.w3.org/2000/svg" width="11" height="9" viewBox="0 0 11 9" fill="none"><path d="M0.299988 4.30005H10.3M10.3 4.30005L6.13332 0.300049M10.3 4.30005L6.13332 8.30005" stroke="#275FA6" stroke-width="0.6" stroke-linecap="round" stroke-linejoin="round"/></svg>
                            </span>
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
</div>