/**
 * Newsletter CTA Block - Minimal JavaScript
 * Basic functionality for newsletter signup form
 */

document.addEventListener('DOMContentLoaded', function() {
    const newsletterContainers = document.querySelectorAll('.newsletter-cta');
    
    newsletterContainers.forEach(function(container) {
        const form = container.querySelector('.newsletter__form-element');
        const emailInput = container.querySelector('.newsletter__input');
        const button = container.querySelector('.newsletter__button');
        
        if (!form || !emailInput || !button) return;
        
        // Form submission with loading state
        form.addEventListener('submit', function(e) {
            if (!isValidEmail(emailInput.value)) {
                e.preventDefault();
                return;
            }
            
            // Show loading state
            button.disabled = true;
            button.textContent = 'Subscribing...';
            
        });
    });
});

function isValidEmail(email) {
    return /^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(email);
}