<?php
// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Get field values
$cta_version = $fields['cta_version'] ?? 'signup';
$signup_cta = $fields['signup_cta'] ?? [];
$link_cta = $fields['link_cta'] ?? [];
$background_color = $fields['background_color'] ?? '#2c3e50';
$text_color = $fields['text_color'] ?? '#ffffff';
$link_color = $fields['link_color'] ?? '#007bff';
$envelope_svg = $fields['envelope_svg'] ?? '';

// Set CSS custom properties
$css_vars = [
    '--cta-bg-color' => $background_color,
    '--cta-text-color' => $text_color,
    '--cta-link-color' => $link_color,
];
$css_vars_string = '';
foreach ($css_vars as $property => $value) {
    $css_vars_string .= $property . ': ' . esc_attr($value) . '; ';
}
?>

<div class="sports-cta" style="<?php echo $css_vars_string; ?>">
    <?php if ($cta_version === 'signup'): ?>
        <!-- Signup CTA Version -->
        <div class="sports-cta__signup">
            <div class="sports-cta__content">
                <div class="sports-cta__text">
                    <div class="sports-cta__main-text">
                        <?php if (!empty($envelope_svg)): ?>
                            <span class="sports-cta__icon">
                                <?php echo $envelope_svg; ?>
                            </span>
                        <?php endif; ?>
                        <?php echo esc_html($signup_cta['main_text'] ?? 'Like this insight? Get daily previews & picks.'); ?>
                    </div>
                    <?php if (!empty($signup_cta['sub_text'])): ?>
                        <div class="sports-cta__sub-text">
                            <?php echo esc_html($signup_cta['sub_text']); ?>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="sports-cta__action">
                    <?php 
                    $button_link = $signup_cta['button_link'] ?? [];
                    $button_text = $button_link['title'] ?? 'Sign Up Free';
                    $button_url = $button_link['url'] ?? '#';
                    $button_target = $button_link['target'] ?? '_self';
                    ?>
                    <a href="<?php echo esc_url($button_url); ?>" target="<?php echo esc_attr($button_target); ?>" class="sports-cta__button">
                        <?php echo esc_html($button_text); ?>
                    </a>
                </div>
            </div>
        </div>
    <?php else: ?>
        <!-- Link CTA Version -->
        <div class="sports-cta__link">
            <div class="sports-cta__content">
                <div class="sports-cta__text">
                    <span class="sports-cta__main-text">
                        <?php echo esc_html($link_cta['main_text'] ?? 'Looking for more sports analysis?'); ?>
                    </span>
                    <?php 
                    $link_data = $link_cta['link'] ?? [];
                    $link_text = $link_data['title'] ?? 'See all sports previews here';
                    $link_url = $link_data['url'] ?? '#';
                    $link_target = $link_data['target'] ?? '_self';
                    ?>
                    <a href="<?php echo esc_url($link_url); ?>" target="<?php echo esc_attr($link_target); ?>" class="sports-cta__link-element">
                        <?php echo esc_html($link_text); ?>
                        <span class="sports-cta__external-icon">
                            <svg width="14" height="14" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M18 13V19C18 19.5304 17.7893 20.0391 17.4142 20.4142C17.0391 20.7893 16.5304 21 16 21H5C4.46957 21 3.96086 20.7893 3.58579 20.4142C3.21071 20.0391 3 19.5304 3 19V8C3 7.46957 3.21071 6.96086 3.58579 6.58579C3.96086 6.21071 4.46957 6 5 6H11" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                <polyline points="15,3 21,3 21,9" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                <line x1="10" y1="14" x2="21" y2="3" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </span>
                    </a>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>
