<?php
// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Get field values
$title = $fields['title'] ?? 'The Lean - Team A vs Team B Prediction';
$analysis_text = $fields['analysis_text'] ?? '';
$expert_prediction = $fields['expert_prediction'] ?? 'Team B -3 and UNDER 48.5';
$confidence_level = $fields['confidence_level'] ?? '7/10';
$expected_value = $fields['expected_value'] ?? '+12%';
$cta_text = $fields['cta_text'] ?? 'Want more sports predictions? See all sports previews here';
$cta_link = $fields['cta_link'] ?? null;
$disclaimer = $fields['disclaimer'] ?? '*This is analysis only. Always bet responsibly and within your means. Must be 21+.';
$prediction_bg_color = $fields['prediction_background_color'] ?? '#1a1a1a';
$prediction_text_color = $fields['prediction_text_color'] ?? '#ffffff';
$show_icon = $fields['show_icon'] ?? true;
$custom_icon_svg = $fields['custom_icon_svg'] ?? '';
$icon_color = $fields['icon_color'] ?? '#ff6b6b';

// Set CSS custom properties
$css_vars = [
    '--prediction-bg-color' => $prediction_bg_color,
    '--prediction-text-color' => $prediction_text_color,
    '--icon-color' => $icon_color,
];
$css_vars_string = '';
foreach ($css_vars as $property => $value) {
    $css_vars_string .= $property . ': ' . esc_attr($value) . '; ';
}
?>

<div class="sports-prediction" style="<?php echo $css_vars_string; ?>">
    <!-- Title Section -->
    <div class="sports-prediction__header">
        <p class="sports-prediction__title"><?php echo esc_html($title); ?></p>
    </div>

    <!-- Analysis Text Section -->
    <?php if ($analysis_text): ?>
        <div class="sports-prediction__analysis">
            <p class="sports-prediction__text"><?php echo esc_html($analysis_text); ?></p>
        </div>
    <?php endif; ?>

    <!-- Expert Prediction Section -->
    <div class="sports-prediction__expert">
        <div class="sports-prediction__expert-header">
            <?php if ($show_icon): ?>
                <div class="sports-prediction__icon">
                    <?php if (!empty($custom_icon_svg)): ?>
                        <?php echo $custom_icon_svg; ?>
                    <?php else: ?>
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <circle cx="12" cy="12" r="10" stroke="currentColor" stroke-width="2"/>
                            <circle cx="12" cy="12" r="6" stroke="currentColor" stroke-width="2"/>
                            <circle cx="12" cy="12" r="2" fill="currentColor"/>
                        </svg>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
            <p class="sports-prediction__label">Our Expert Prediction</p>
        </div>
        
        <div class="sports-prediction__content">
            <div class="sports-prediction__prediction">
                <?php echo esc_html($expert_prediction); ?>
            </div>
            
            <div class="sports-prediction__metrics">
                <span class="sports-prediction__confidence">Confidence Level: <?php echo esc_html($confidence_level); ?></span>
                <?php if ($expected_value): ?>
                    <span class="sports-prediction__separator">|</span>
                    <span class="sports-prediction__value">Expected Value: <?php echo esc_html($expected_value); ?></span>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- CTA Section -->
    <?php if ($cta_link && !empty($cta_link['url'])): ?>
        <div class="sports-prediction__cta">
            <div class="sports-prediction__cta-content">
                <?php if ($cta_text): ?>
                    <p class="sports-prediction__cta-text"><?php echo esc_html($cta_text); ?></p>
                <?php endif; ?>
                <a href="<?php echo esc_url($cta_link['url']); ?>" 
                   class="sports-prediction__link"
                   <?php if (!empty($cta_link['target'])): ?>target="<?php echo esc_attr($cta_link['target']); ?>"<?php endif; ?>>
                    <?php echo esc_html($cta_link['title'] ?? 'Learn More'); ?>
                    <span class="sports-prediction__link-icon">
                        <svg width="14" height="14" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M18 13V19C18 19.5304 17.7893 20.0391 17.4142 20.4142C17.0391 20.7893 16.5304 21 16 21H5C4.46957 21 3.96086 20.7893 3.58579 20.4142C3.21071 20.0391 3 19.5304 3 19V8C3 7.46957 3.21071 6.96086 3.58579 6.58579C3.96086 6.21071 4.46957 6 5 6H11" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            <polyline points="15,3 21,3 21,9" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            <line x1="10" y1="14" x2="21" y2="3" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                    </span>
                </a>
            </div>
        </div>
    <?php endif; ?>

    <!-- Disclaimer Section -->
    <?php if ($disclaimer): ?>
        <div class="sports-prediction__disclaimer">
            <p class="sports-prediction__disclaimer-text"><?php echo esc_html($disclaimer); ?></p>
        </div>
    <?php endif; ?>
</div>
