<?php
/**
 * Mobile Newsletter Banner Block Configuration
 */

function smarter_blocks_mobile_newsletter_banner_config() {
    return [
        'name' => 'mobile-newsletter-banner',
        'title' => 'Mobile Newsletter Banner',
        'description' => 'Display a sticky promotional banner for mobile devices with newsletter signup call-to-action.',
        'category' => 'widgets',
        'icon' => 'smartphone',
        'keywords' => ['mobile', 'banner', 'newsletter', 'sticky', 'promo', 'cta'],
        'supports' => [
            'align' => false,
            'mode' => true,
            'jsx' => false,
        ],
        'example' => [
            'attributes' => [
                'mode' => 'preview',
                'data' => [
                    'primary_text' => 'Get Free Daily Picks',
                    'secondary_text' => 'Join 50k+ winning bettors',
                    'cta_link' => [
                        'url' => '#',
                        'title' => 'Sign Up',
                    ],
                ],
            ],
        ],
        'mode' => 'preview',
    ];
}

