<?php
/**
 * Sports Stats Display Block Configuration
 */

function smarter_blocks_sports_stats_display_config() {
    return [
        'name' => 'sports-stats-display',
        'title' => 'Sports Stats Display',
        'description' => 'Display sports statistics in 3 fixed cards: stats, injuries, and betting trends with customizable grid layout.',
        'category' => 'widgets',
        'icon' => 'chart-bar',
        'keywords' => ['sports', 'stats', 'cards', 'betting', 'injuries', 'trends'],
        'supports' => [
            'align' => false,
            'mode' => true,
            'jsx' => false,
        ],
        'example' => [
            'attributes' => [
                'mode' => 'preview',
                'data' => [
                    'background_color' => '#1a1a1a',
                    'card_background' => '#ffffff',
                    'link_color' => '#007bff',
                    'show_stats_card' => true,
                    'show_injuries_card' => true,
                    'show_trends_card' => true,
                    'stats_card' => [
                        'title' => 'Falcons Record & ATS Stats',
                        'icon' => '<svg width="16" height="16" viewBox="0 0 24 24" fill="none"><path d="M7 14l3-3 3 3 5-5" stroke="currentColor" stroke-width="2"/></svg>',
                        'stats' => [
                            ['label' => 'Atlanta SU/ATS:', 'value' => '2-1 / 1-2'],
                            ['label' => 'Washington SU/ATS:', 'value' => '2-1 / 2-1'],
                            ['label' => 'Last 5 H2H:', 'value' => 'ATL 3-2'],
                            ['label' => 'Home field advantage:', 'value' => 'WAS 8-2 L10']
                        ],
                        'footer_link' => [
                            'text' => 'See full NFL betting trends',
                            'url' => '#',
                            'icon' => '<svg width="14" height="14" viewBox="0 0 24 24" fill="none"><path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/></svg>'
                        ]
                    ]
                ],
            ],
        ],
        'mode' => 'preview',
    ];
}
