<?php
/**
 * Expert Betting Insights Block Configuration
 */

function smarter_blocks_expert_betting_insights_config() {
    return [
        'name' => 'expert-betting-insights',
        'title' => 'Expert Betting Insights',
        'description' => 'A dark-themed block displaying expert betting insights in Q&A format with insights cards and call-to-action button.',
        'category' => 'widgets',
        'icon' => 'chart-line',
        'keywords' => ['expert', 'betting', 'insights', 'trends', 'analysis', 'q&a', 'dark'],
        'supports' => [
            'align' => false,
            'mode' => true,
            'jsx' => false,
        ],
        'example' => [
            'attributes' => [
                'mode' => 'preview',
                'data' => [
                    'title' => 'Expert Betting Insights',
                    'insights' => [
                        [
                            'question' => 'What is the Falcons\' ATS record on the road?',
                            'answer' => 'Falcons are 5-1 ATS in their last 6 road games, showing strong value as underdogs away from home.'
                        ],
                        [
                            'question' => 'How do totals perform in Commanders home games?',
                            'answer' => 'Washington home games have gone UNDER in 6 of their last 8 contests, with an average total of 45.2 points.'
                        ],
                        [
                            'question' => 'How do NFC East vs NFC South matchups trend?',
                            'answer' => 'NFC South teams are 12-4 ATS on the road this season when facing NFC East opponents, indicating strong cross-division value.'
                        ]
                    ],
                    'button_text' => 'Get More Trends - Free Signup',
                    'button_url' => '#'
                ],
            ],
        ],
        'mode' => 'preview',
    ];
}
