<?php
/**
 * Testimonials Block Configuration
 */

function smarter_blocks_testimonials_config() {
    return [
        'name' => 'testimonials',
        'title' => 'Testimonials',
        'description' => 'A testimonials section with customer reviews and ratings.',
        'category' => 'widgets',
        'icon' => 'format-quote',
        'keywords' => ['testimonials', 'reviews', 'quotes', 'feedback', 'customers'],
        'supports' => [
            'align' => ['wide', 'full'],
            'align_text' => true,
            'align_content' => true,
        ],
        'example' => [
            'title' => 'What Our Customers Say',
            'subtitle' => 'Real feedback from satisfied customers',
            'testimonials' => [
                [
                    'name' => 'John Doe',
                    'position' => 'CEO, Company Inc.',
                    'content' => 'Amazing service and quality!',
                    'rating' => 5
                ]
            ]
        ],
        'mode' => 'preview',
        'align' => 'wide',
        'align_text' => 'center',
        'align_content' => 'center',
    ];
}
