<?php
/**
 * Bookie Promo Block ACF Fields
 */

if (!function_exists('acf_add_local_field_group')) {
    return;
}

acf_add_local_field_group([
    'key' => 'group_bookie_promo',
    'title' => 'Bookie Promo Configuration',
    'fields' => [
        [
            'key' => 'field_logo',
            'label' => 'Logo',
            'name' => 'logo',
            'type' => 'image',
            'return_format' => 'array',
            'preview_size' => 'medium',
            'library' => 'all',
            'wrapper' => [
                'width' => '100',
            ],
        ],
        [
            'key' => 'field_promo_text',
            'label' => 'Promotional Text',
            'name' => 'promo_text',
            'type' => 'group',
            'layout' => 'block',
            'sub_fields' => [
                [
                    'key' => 'field_promo_label',
                    'label' => 'Label (Top)',
                    'name' => 'label',
                    'type' => 'text',
                    'default_value' => 'Get up to:',
                    'placeholder' => 'e.g., Get up to:',
                    'wrapper' => [
                        'width' => '100',
                    ],
                ],
                [
                    'key' => 'field_promo_title',
                    'label' => 'Title (Large)',
                    'name' => 'title',
                    'type' => 'text',
                    'required' => 1,
                    'default_value' => 'Same Day Payouts',
                    'placeholder' => 'e.g., Same Day Payouts',
                    'wrapper' => [
                        'width' => '100',
                    ],
                ],
                [
                    'key' => 'field_promo_subtitle',
                    'label' => 'Subtitle',
                    'name' => 'subtitle',
                    'type' => 'text',
                    'default_value' => 'DBL your Bankroll',
                    'placeholder' => 'e.g., DBL your Bankroll',
                    'wrapper' => [
                        'width' => '100',
                    ],
                ],
                [
                    'key' => 'field_promo_offer',
                    'label' => 'Offer (Bottom)',
                    'name' => 'offer',
                    'type' => 'text',
                    'default_value' => 'Send $500 get $500 FREE',
                    'placeholder' => 'e.g., Send $500 get $500 FREE',
                    'wrapper' => [
                        'width' => '100',
                    ],
                ],
            ],
        ],
        [
            'key' => 'field_rating',
            'label' => 'Rating',
            'name' => 'rating',
            'type' => 'number',
            'required' => 1,
            'default_value' => 5,
            'min' => 1,
            'max' => 5,
            'step' => 1,
            'wrapper' => [
                'width' => '50',
            ],
        ],
        [
            'key' => 'field_rating_color',
            'label' => 'Rating Star Color',
            'name' => 'rating_color',
            'type' => 'color_picker',
            'default_value' => '#2563eb',
            'wrapper' => [
                'width' => '50',
            ],
        ],
        [
            'key' => 'field_buttons',
            'label' => 'Buttons',
            'name' => 'buttons',
            'type' => 'group',
            'layout' => 'block',
            'sub_fields' => [
                [
                    'key' => 'field_play_now_link',
                    'label' => 'Play Now Link',
                    'name' => 'play_now_link',
                    'type' => 'link',
                    'return_format' => 'array',
                    'wrapper' => [
                        'width' => '100',
                    ],
                ],
                [
                    'key' => 'field_play_now_color',
                    'label' => 'Play Now Button Color',
                    'name' => 'play_now_color',
                    'type' => 'color_picker',
                    'default_value' => '#2563eb',
                    'wrapper' => [
                        'width' => '100',
                    ],
                ],
                [
                    'key' => 'field_read_review_link',
                    'label' => 'Read Review Link',
                    'name' => 'read_review_link',
                    'type' => 'link',
                    'return_format' => 'array',
                    'wrapper' => [
                        'width' => '100',
                    ],
                ],
            ],
        ],
        [
            'key' => 'field_card_background',
            'label' => 'Card Background Color',
            'name' => 'card_background',
            'type' => 'color_picker',
            'default_value' => '#ffffff',
            'wrapper' => [
                'width' => '100',
            ],
        ],
    ],
    'location' => [
        [
            [
                'param' => 'block',
                'operator' => '==',
                'value' => 'acf/bookie-promo',
            ],
        ],
    ],
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => 'Configure promotional card for betting/gaming platform.',
]);

