<?php
// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Get field values
$logo = $fields['logo'] ?? null;
$promo_text = $fields['promo_text'] ?? [];
$rating = $fields['rating'] ?? 5;
$rating_color = $fields['rating_color'] ?? '#2563eb';
$buttons = $fields['buttons'] ?? [];
$card_background = $fields['card_background'] ?? '#ffffff';

// Set CSS custom properties
$css_vars = [
    '--bookie-promo-card-bg' => $card_background,
    '--bookie-promo-rating-color' => $rating_color,
    '--bookie-promo-play-now-color' => $buttons['play_now_color'] ?? '#2563eb',
];

$css_vars_string = '';
foreach ($css_vars as $property => $value) {
    $css_vars_string .= $property . ': ' . esc_attr($value) . '; ';
}

// Generate stars for rating (only full stars, 1-5)
$full_stars = (int) $rating;
?>

<div class="bookie-promo" style="<?php echo $css_vars_string; ?>">
    <div class="bookie-promo__card">
        <!-- Left Section: Badge and Logo -->
        <div class="bookie-promo__left-section">
            <!-- Logo Section -->
            <div class="bookie-promo__logo-section">
                <?php if ($logo): ?>
                    <div class="bookie-promo__logo">
                        <img src="<?php echo esc_url($logo['url']); ?>" alt="<?php echo esc_attr($logo['alt'] ?? ''); ?>" class="bookie-promo__logo-image">
                    </div>
                <?php endif; ?>
                <!-- Rating Section -->
                <div class="bookie-promo__rating-section">
                    <div class="bookie-promo__stars">
                        <?php for ($i = 0; $i < 5; $i++): ?>
                            <?php if ($i < $full_stars): ?>
                                <span class="bookie-promo__star bookie-promo__star--full">★</span>
                            <?php else: ?>
                                <span class="bookie-promo__star bookie-promo__star--empty">★</span>
                            <?php endif; ?>
                        <?php endfor; ?>
                    </div>
                    <div class="bookie-promo__rating-text"><?php echo esc_html($rating); ?></div>
                </div>
            </div>
        </div>

        <!-- Divider -->
        <div class="bookie-promo__divider"></div>

        <!-- Promotional Text Section -->
        <div class="bookie-promo__promo-section">
            <?php if (!empty($promo_text['label'])): ?>
                <div class="bookie-promo__promo-label"><?php echo esc_html($promo_text['label']); ?></div>
            <?php endif; ?>
            <?php if (!empty($promo_text['title'])): ?>
                <div class="bookie-promo__promo-title"><?php echo esc_html($promo_text['title']); ?></div>
            <?php endif; ?>
            <?php if (!empty($promo_text['subtitle'])): ?>
                <div class="bookie-promo__promo-subtitle"><?php echo esc_html($promo_text['subtitle']); ?></div>
            <?php endif; ?>
            <?php if (!empty($promo_text['offer'])): ?>
                <div class="bookie-promo__promo-offer"><?php echo esc_html($promo_text['offer']); ?></div>
            <?php endif; ?>
        </div>        

        <!-- Divider -->
        <div class="bookie-promo__divider"></div>

        <!-- Buttons Section -->
        <div class="bookie-promo__buttons">
            <?php 
            $play_now_link = $buttons['play_now_link'] ?? null;
            if ($play_now_link && !empty($play_now_link['url'])): 
            ?>
                <a href="<?php echo esc_url($play_now_link['url']); ?>" 
                   target="<?php echo esc_attr($play_now_link['target'] ?? '_self'); ?>"
                   class="bookie-promo__button bookie-promo__button--primary">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 640">
                        <path d="M320 576C178.6 576 64 461.4 64 320C64 178.6 178.6 64 320 64C461.4 64 576 178.6 576 320C576 461.4 461.4 576 320 576zM438 209.7C427.3 201.9 412.3 204.3 404.5 215L285.1 379.2L233 327.1C223.6 317.7 208.4 317.7 199.1 327.1C189.8 336.5 189.7 351.7 199.1 361L271.1 433C276.1 438 282.9 440.5 289.9 440C296.9 439.5 303.3 435.9 307.4 430.2L443.3 243.2C451.1 232.5 448.7 217.5 438 209.7z"/>
                    </svg>
                    <span class="bookie-promo__button-text"><?php echo esc_html($play_now_link['title'] ?? $buttons['play_now_text'] ?? 'Play Now'); ?></span>
                </a>
            <?php endif; ?>
            <?php 
            $read_review_link = $buttons['read_review_link'] ?? null;
            if ($read_review_link && !empty($read_review_link['url'])): 
            ?>
                <a href="<?php echo esc_url($read_review_link['url']); ?>" 
                   target="<?php echo esc_attr($read_review_link['target'] ?? '_self'); ?>"
                   class="bookie-promo__button bookie-promo__button--secondary">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 640">
                            <path d="M320 576C461.4 576 576 461.4 576 320C576 178.6 461.4 64 320 64C178.6 64 64 178.6 64 320C64 461.4 178.6 576 320 576zM361 417C351.6 426.4 336.4 426.4 327.1 417C317.8 407.6 317.7 392.4 327.1 383.1L366.1 344.1L216 344.1C202.7 344.1 192 333.4 192 320.1C192 306.8 202.7 296.1 216 296.1L366.1 296.1L327.1 257.1C317.7 247.7 317.7 232.5 327.1 223.2C336.5 213.9 351.7 213.8 361 223.2L441 303.2C450.4 312.6 450.4 327.8 441 337.1L361 417.1z"/>
                        </svg>
                    <span class="bookie-promo__button-text"><?php echo esc_html($read_review_link['title'] ?? $buttons['read_review_text'] ?? 'Read Review'); ?></span>
                </a>
            <?php endif; ?>
        </div>
    </div>
</div>

