<?php
/**
 * Hero Section Block ACF Fields
 */

if (!function_exists('acf_add_local_field_group')) {
    return;
}

acf_add_local_field_group([
        'key' => 'group_hero_section',
        'title' => 'Hero Section',
        'fields' => [
            [
                'key' => 'field_hero_title',
                'label' => 'Title',
                'name' => 'title',
                'type' => 'text',
                'required' => 1,
                'default_value' => 'Welcome to Our Website',
            ],
            [
                'key' => 'field_hero_subtitle',
                'label' => 'Subtitle',
                'name' => 'subtitle',
                'type' => 'text',
                'required' => 0,
            ],
            [
                'key' => 'field_hero_abstract',
                'label' => 'Abstract',
                'name' => 'abstract',
                'type' => 'wysiwyg',
                'required' => 0,
                'tabs'     => 'all',
                'toolbar'  => 'full',
                'media_upload' => 1,
            ],
            [
                'key' => 'field_hero_background_image',
                'label' => 'Background Image',
                'name' => 'background_image',
                'type' => 'image',
                'required' => 0,
            ],
            [
                'key' => 'field_hero_background_color',
                'label' => 'Background Color',
                'name' => 'background_color',
                'type' => 'color_picker',
                'required' => 0,
                'default_value' => '#000',
            ],
            [
                'key' => 'field_hero_buttons_repeater',
                'label' => 'Buttons',
                'name' => 'buttons_repeater',
                'type' => 'repeater',
                'layout'   => 'row',
                'required' => 0,
                'sub_fields' => [
                    [
                        'key'   => 'field_hero_button_link',
                        'label' => 'Button',
                        'name'  => 'button',
                        'type'  => 'link',
                        'return_format' => 'array',
                    ],
                    [
                        'key'   => 'field_hero_button_icon',
                        'label' => 'Icon',
                        'name'  => 'icon',
                        'type'  => 'icon_picker',
                        'tabs'  => ['dashicons','media_library','url'],
                        'return_format' => 'array',
                    ],
                ],
            ],
            [
                'key'      => 'field_hero_cta',
                'label'    => 'CTA',
                'name'     => 'cta',
                'type'     => 'group',
                'layout'   => 'row',
                'sub_fields' => [
                    [
                        'key'   => 'field_hero_cta_title',
                        'label' => 'Title',
                        'name'  => 'title',
                        'type'  => 'text',
                    ],
                    [
                        'key'   => 'field_hero_cta_subtitle',
                        'label' => 'Subtitle',
                        'name'  => 'subtitle',
                        'type'  => 'text',
                    ],
                    [
                        'key'   => 'field_hero_cta_image',
                        'label' => 'Image',
                        'name'  => 'image',
                        'type'  => 'image',
                        'return_format' => 'array',
                        'preview_size'  => 'medium',
                    ],
                    [
                        'key'   => 'field_hero_cta_button',
                        'label' => 'Button',
                        'name'  => 'button',
                        'type'  => 'link',
                        'return_format' => 'array',
                    ],
                ],
            ],
        ],
        'location' => [
            [
                [
                    'param' => 'block',
                    'operator' => '==',
                    'value' => 'acf/hero-section',
                ],
            ],
        ],
        'menu_order' => 0,
        'position' => 'normal',
        'style' => 'default',
        'label_placement' => 'top',
        'instruction_placement' => 'label',
        'hide_on_screen' => '',
        'active' => true,
        'description' => '',
    ]);

