<?php
/**
 * Mobile Newsletter Banner Block ACF Fields
 */

if (!function_exists('acf_add_local_field_group')) {
    return;
}

acf_add_local_field_group([
    'key' => 'group_mobile_newsletter_banner',
    'title' => 'Mobile Newsletter Banner Configuration',
    'fields' => [
        [
            'key' => 'field_primary_text',
            'label' => 'Primary Text',
            'name' => 'primary_text',
            'type' => 'text',
            'required' => 1,
            'default_value' => 'Get Free Daily Picks',
            'placeholder' => 'e.g., Get Free Daily Picks',
            'wrapper' => [
                'width' => '100',
            ],
        ],
        [
            'key' => 'field_secondary_text',
            'label' => 'Secondary Text',
            'name' => 'secondary_text',
            'type' => 'text',
            'default_value' => 'Join 50k+ winning bettors',
            'placeholder' => 'e.g., Join 50k+ winning bettors',
            'wrapper' => [
                'width' => '100',
            ],
        ],
        [
            'key' => 'field_cta_link',
            'label' => 'Call to Action Link',
            'name' => 'cta_link',
            'type' => 'link',
            'required' => 1,
            'return_format' => 'array',
            'wrapper' => [
                'width' => '100',
            ],
        ],
        [
            'key' => 'field_banner_background_color',
            'label' => 'Banner Background Color',
            'name' => 'banner_background_color',
            'type' => 'color_picker',
            'default_value' => '#22c55e',
            'wrapper' => [
                'width' => '50',
            ],
        ],
        [
            'key' => 'field_button_background_color',
            'label' => 'Button Background Color',
            'name' => 'button_background_color',
            'type' => 'color_picker',
            'default_value' => '#fbbf24',
            'wrapper' => [
                'width' => '50',
            ],
        ],
        [
            'key' => 'field_show_close_button',
            'label' => 'Show Close Button',
            'name' => 'show_close_button',
            'type' => 'true_false',
            'default_value' => 1,
            'ui' => 1,
            'wrapper' => [
                'width' => '100',
            ],
        ],
    ],
    'location' => [
        [
            [
                'param' => 'block',
                'operator' => '==',
                'value' => 'acf/mobile-newsletter-banner',
            ],
        ],
    ],
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => 'Configure sticky mobile newsletter banner with call-to-action.',
]);

