/**
 * Mobile Newsletter Banner Script
 * Simple close functionality without persistence
 */

(function() {
    'use strict';

    // Wait for DOM to be ready
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', init);
    } else {
        init();
    }

    function init() {
        const banners = document.querySelectorAll('.mobile-newsletter-banner');
        
        banners.forEach(function(banner) {
            const closeButton = banner.querySelector('.mobile-newsletter-banner__close');
            
            // Add close functionality
            if (closeButton) {
                closeButton.addEventListener('click', function(e) {
                    e.preventDefault();
                    e.stopPropagation();
                    
                    // Hide banner with animation
                    banner.style.transition = 'transform 0.3s ease, opacity 0.3s ease';
                    banner.style.transform = 'translateY(100%)';
                    banner.style.opacity = '0';
                    
                    // Remove from DOM after animation
                    setTimeout(function() {
                        banner.style.display = 'none';
                    }, 300);
                });
            }
        });
    }
})();

