<?php
/**
 * Newsletter CTA Block ACF Fields
 */

if (!function_exists('acf_add_local_field_group')) {
    return;
}

acf_add_local_field_group([
    'key' => 'group_newsletter_cta',
    'title' => 'Newsletter CTA Configuration',
    'fields' => [
        [
            'key' => 'field_main_headline',
            'label' => 'Main Headline',
            'name' => 'main_headline',
            'type' => 'text',
            'required' => 1,
            'placeholder' => 'e.g., Stay Updated - Subscribe to Our Newsletter',
            'default_value' => 'Stay Updated - Subscribe to Our Newsletter',
        ],
        [
            'key' => 'field_sub_headline',
            'label' => 'Sub Headline',
            'name' => 'sub_headline',
            'type' => 'text',
            'required' => 0,
            'placeholder' => 'e.g., Join thousands of subscribers and get the latest updates delivered to your inbox',
            'default_value' => 'Join thousands of subscribers and get the latest updates delivered to your inbox',
        ],
        [
            'key' => 'field_email_placeholder',
            'label' => 'Email Placeholder Text',
            'name' => 'email_placeholder',
            'type' => 'text',
            'required' => 0,
            'placeholder' => 'e.g., Enter your email address',
            'default_value' => 'Enter your email address',
        ],
        [
            'key' => 'field_button_text',
            'label' => 'Button Text',
            'name' => 'button_text',
            'type' => 'text',
            'required' => 1,
            'placeholder' => 'e.g., Subscribe Now',
            'default_value' => 'Subscribe Now',
        ],
        [
            'key' => 'field_features_repeater',
            'label' => 'Features List',
            'name' => 'features',
            'type' => 'repeater',
            'layout' => 'table',
            'required' => 1,
            'min' => 1,
            'max' => 5,
            'button_label' => 'Add Feature',
            'sub_fields' => [
                [
                    'key' => 'field_feature_text',
                    'label' => 'Feature Text',
                    'name' => 'text',
                    'type' => 'text',
                    'required' => 1,
                    'placeholder' => 'e.g., Weekly newsletter with exclusive content',
                ],
            ],
        ],
        [
            'key' => 'field_privacy_text',
            'label' => 'Privacy Text',
            'name' => 'privacy_text',
            'type' => 'text',
            'required' => 0,
            'placeholder' => 'e.g., No spam. Unsubscribe anytime. We respect your privacy.',
            'default_value' => 'No spam. Unsubscribe anytime. We respect your privacy.',
        ],
        [
            'key' => 'field_background_color',
            'label' => 'Background Color',
            'name' => 'background_color',
            'type' => 'color_picker',
            'required' => 0,
            'default_value' => '#1a1a1a',
            'instructions' => 'Main background color for the newsletter CTA block.',
        ],
        [
            'key' => 'field_text_color',
            'label' => 'Text Color',
            'name' => 'text_color',
            'type' => 'color_picker',
            'required' => 0,
            'default_value' => '#ffffff',
            'instructions' => 'Text color for the newsletter CTA block.',
        ],
        [
            'key' => 'field_show_icon',
            'label' => 'Show Icon',
            'name' => 'show_icon',
            'type' => 'true_false',
            'required' => 0,
            'default_value' => 1,
            'instructions' => 'Show or hide the flame icon in the headline.',
            'ui' => 1,
        ],
        [
            'key' => 'field_custom_icon_svg',
            'label' => 'Custom Icon SVG',
            'name' => 'custom_icon_svg',
            'type' => 'textarea',
            'required' => 0,
            'placeholder' => '<svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">...</svg>',
            'instructions' => 'Custom SVG code for the icon. Leave empty to use default flame icon.',
            'rows' => 4,
        ],
        [
            'key' => 'field_checkmark_color',
            'label' => 'Checkmark Color',
            'name' => 'checkmark_color',
            'type' => 'color_picker',
            'required' => 0,
            'default_value' => '#32cd32',
            'instructions' => 'Color for the checkmark icons.',
        ],
    ],
    'location' => [
        [
            [
                'param' => 'block',
                'operator' => '==',
                'value' => 'acf/newsletter-cta',
            ],
        ],
    ],
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => 'Configure the Newsletter CTA block with email capture form and features list.',
]);
