<?php
/**
 * Sports Match-up Block ACF Fields
 */

if (!function_exists('acf_add_local_field_group')) {
    return;
}

acf_add_local_field_group([
    'key' => 'group_sports_matchup',
    'title' => 'Sports Match-up Configuration',
    'fields' => [
        [
            'key' => 'field_card_background',
            'label' => 'Card Background',
            'name' => 'card_background',
            'type' => 'color_picker',
            'default_value' => '#ffffff',
            'wrapper' => [
                'width' => '100',
            ],
        ],
        [
            'key' => 'field_team1',
            'label' => 'Team 1 (Left)',
            'name' => 'team1',
            'type' => 'group',
            'layout' => 'block',
            'sub_fields' => [
                [
                    'key' => 'field_team1_name',
                    'label' => 'Team 1 Name',
                    'name' => 'name',
                    'type' => 'text',
                    'required' => 1,
                    'placeholder' => 'e.g., Atlanta Falcons',
                    'wrapper' => [
                        'width' => '100',
                    ],
                ],
                [
                    'key' => 'field_team1_abbreviation',
                    'label' => 'Abbreviation',
                    'name' => 'abbreviation',
                    'type' => 'text',
                    'required' => 1,
                    'placeholder' => 'e.g., ATL',
                    'maxlength' => 3,
                    'wrapper' => [
                        'width' => '100',
                    ],
                ],
                [
                    'key' => 'field_team1_color',
                    'label' => 'Team Color',
                    'name' => 'color',
                    'type' => 'color_picker',
                    'default_value' => '#E50000',
                    'wrapper' => [
                        'width' => '100',
                    ],
                ],
                [
                    'key' => 'field_team1_record',
                    'label' => 'Record',
                    'name' => 'record',
                    'type' => 'text',
                    'required' => 1,
                    'placeholder' => 'e.g., 2-1 (1-2 ATS)',
                    'wrapper' => [
                        'width' => '100',
                    ],
                ],
            ],
        ],
        [
            'key' => 'field_team2',
            'label' => 'Team 2 (Right)',
            'name' => 'team2',
            'type' => 'group',
            'layout' => 'block',
            'sub_fields' => [
                [
                    'key' => 'field_team2_name',
                    'label' => 'Team 2 Name',
                    'name' => 'name',
                    'type' => 'text',
                    'required' => 1,
                    'placeholder' => 'e.g., Washington Commanders',
                    'wrapper' => [
                        'width' => '100',
                    ],
                ],
                [
                    'key' => 'field_team2_abbreviation',
                    'label' => 'Abbreviation',
                    'name' => 'abbreviation',
                    'type' => 'text',
                    'required' => 1,
                    'placeholder' => 'e.g., WAS',
                    'maxlength' => 3,
                    'wrapper' => [
                        'width' => '100',
                    ],
                ],
                [
                    'key' => 'field_team2_color',
                    'label' => 'Team Color',
                    'name' => 'color',
                    'type' => 'color_picker',
                    'default_value' => '#A07828',
                    'wrapper' => [
                        'width' => '100',
                    ],
                ],
                [
                    'key' => 'field_team2_record',
                    'label' => 'Record',
                    'name' => 'record',
                    'type' => 'text',
                    'required' => 1,
                    'placeholder' => 'e.g., 2-1 (2-1 ATS)',
                    'wrapper' => [
                        'width' => '100',
                    ],
                ],
            ],
        ],
        [
            'key' => 'field_betting_odds',
            'label' => 'Betting Odds',
            'name' => 'betting_odds',
            'type' => 'group',
            'layout' => 'block',
            'sub_fields' => [
                [
                    'key' => 'field_game_status',
                    'label' => 'Game Status',
                    'name' => 'game_status',
                    'type' => 'text',
                    'required' => 1,
                    'placeholder' => 'e.g., LIVE',
                    'wrapper' => [
                        'width' => '100',
                    ],
                ],
                [
                    'key' => 'field_spread',
                    'label' => 'Spread',
                    'name' => 'spread',
                    'type' => 'text',
                    'required' => 1,
                    'placeholder' => 'e.g., WAS -3',
                    'wrapper' => [
                        'width' => '100',
                    ],
                ],
                [
                    'key' => 'field_over_under',
                    'label' => 'Over/Under',
                    'name' => 'over_under',
                    'type' => 'text',
                    'required' => 1,
                    'placeholder' => 'e.g., 48.5',
                    'wrapper' => [
                        'width' => '100',
                    ],
                ],
                [
                    'key' => 'field_moneyline',
                    'label' => 'Moneyline',
                    'name' => 'moneyline',
                    'type' => 'text',
                    'required' => 1,
                    'placeholder' => 'e.g., +125, -150',
                    'wrapper' => [
                        'width' => '100',
                    ],
                ],
            ],
        ],
    ],
    'location' => [
        [
            [
                'param' => 'block',
                'operator' => '==',
                'value' => 'acf/sports-matchup',
            ],
        ],
    ],
    'menu_order' => 0,
    'position' => 'normal',
    'style' => 'default',
    'label_placement' => 'top',
    'instruction_placement' => 'label',
    'hide_on_screen' => '',
    'active' => true,
    'description' => 'Configure sports match-up between two teams with records and betting odds.',
]);
