<?php
require_once get_stylesheet_directory() . '/custom-walker.php';

// Enqueue parent and child theme styles
function shn_base_child_enqueue_styles() {
    wp_enqueue_style( 'shn-base-parent-style', get_template_directory_uri() . '/style.css' );

    wp_enqueue_style(
        'shn-base-child-main-style',
        get_stylesheet_uri(), 
        array('shn-base-parent-style'),
        wp_get_theme()->get('Version') 
    );

    wp_enqueue_style(
        'shn-base-header-style',
        get_stylesheet_directory_uri() . '/css/style-header.css',
        array('shn-base-child-main-style'),
        wp_get_theme()->get('Version')
    );

    wp_enqueue_style(
        'shn-base-footer-style',
        get_stylesheet_directory_uri() . '/css/style-footer.css',
        array('shn-base-header-style'),
        wp_get_theme()->get('Version')
    );

    wp_enqueue_style(
        'shn-base-single-style',
        get_stylesheet_directory_uri() . '/css/style-single.css',
        array('shn-base-header-style'),
        wp_get_theme()->get('Version')
    );

    wp_enqueue_style(
        'shn-base-single-style',
        get_stylesheet_directory_uri() . '/css/style-front.css',
        array('shn-base-header-style'),
        wp_get_theme()->get('Version')
    );
}

add_action( 'wp_enqueue_scripts', 'shn_base_child_enqueue_styles' );

// Register the header menu 
function shn_child_register_menus() {
    register_nav_menus([
        'main_menu' => __('Navbar', 'shn-base-child'),
    ]);
}
add_action('after_setup_theme', 'shn_child_register_menus');

