<?php 
class Custom_Menu_Walker extends Walker_Nav_Menu {
    public function start_lvl( &$output, $depth = 0, $args = null ) {
        $output .= '<div class="dropdown">';
    }

    public function end_lvl( &$output, $depth = 0, $args = null ) {
        $output .= '</div>';
    }

    public function start_el( &$output, $item, $depth = 0, $args = null, $id = 0 ) {
        $classes = (array) $item->classes;

        $custom_classes = array_filter($classes, function($class) {
            return strpos($class, 'menu-item-type-') !== 0 &&
                   strpos($class, 'menu-item-object-') !== 0 &&
                   strpos($class, 'current-') !== 0 &&
                   strpos($class, 'menu-item-has-children') !== 0 &&
                   strpos($class, 'current_page_ancestor') !== 0 &&
                   strpos($class, 'current_page_parent') !== 0 &&
                   strpos($class, 'current_page_item') !== 0 &&
                   strpos($class, 'menu-item') !== 0;
        });

        $class_names = 'menu-item';
        if (!empty($custom_classes)) {
            $class_names .= ' ' . implode(' ', $custom_classes);
        }

        $has_children = in_array('menu-item-has-children', $classes);

        $output .= '<div class="' . esc_attr($class_names) . '">';
        $output .= '<a href="' . esc_url($item->url) . '">' . esc_html($item->title);

        if ($has_children) {
            $output .= ' <svg viewBox="0 0 330 512" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em"><path d="M305.913 197.085c0 2.266-1.133 4.815-2.833 6.514L171.087 335.593c-1.7 1.7-4.249 2.832-6.515 2.832s-4.815-1.133-6.515-2.832L26.064 203.599c-1.7-1.7-2.832-4.248-2.832-6.514s1.132-4.816 2.832-6.515l14.162-14.163c1.7-1.699 3.966-2.832 6.515-2.832 2.266 0 4.815 1.133 6.515 2.832l111.316 111.317 111.316-111.317c1.7-1.699 4.249-2.832 6.515-2.832s4.815 1.133 6.515 2.832l14.162 14.163c1.7 1.7 2.833 4.249 2.833 6.515z"></path></svg>';
        }

        $output .= '</a>';
    }

    public function end_el( &$output, $item, $depth = 0, $args = null ) {
        $output .= '</div>';
    }
}