<footer class="smarterb-footer">
    <div class="footer-container">
        <!-- Main Footer Content -->
        <div class="footer-main">
            <div class="footer-content">
                <!-- Branding Column -->
                <div class="footer-branding">
                    <div class="brand-logo">
                        <?php if (has_custom_logo()) {
                            the_custom_logo();
                        } else { ?>
                            <span class="site-title"><a href="<?php echo esc_url(home_url('/')); ?>"><?php bloginfo('name'); ?></a></span>
                        <?php } ?>
                    </div>
                    <div class="brand-description">
                        <?php
                            if ( is_active_sidebar( 'footer-4' ) ) {
                                dynamic_sidebar( 'footer-4' );
                            }
                        ?>  
                    </div>
                </div>

                <!-- Platform Links -->
                <div class="footer-column">
                    <p class="column-title">Platform</h3>
                    <?php
                        wp_nav_menu([
                            'theme_location' => 'platform_menu',
                            'menu_class'     => 'platform-menu',
                            'container'      => false,
                            'walker'         => new Custom_Menu_Walker(),
                        ]);
                    ?>
                </div>

                <!-- Support Links -->
                <div class="footer-column">
                    <p class="column-title">Support</h3>
                    <?php
                        wp_nav_menu([
                            'theme_location' => 'support_menu',
                            'menu_class'     => 'support-menu',
                            'container'      => false,
                            'walker'         => new Custom_Menu_Walker(),
                        ]);
                    ?>
                </div>

                <!-- Legal Links -->
                <div class="footer-column">
                    <p class="column-title">Legal</h3>
                    <?php
                        wp_nav_menu([
                            'theme_location' => 'legal_menu',
                            'menu_class'     => 'legal-menu',
                            'container'      => false,
                            'walker'         => new Custom_Menu_Walker(),
                        ]);
                    ?>
                </div>
            </div>
        </div>

        <!-- Footer Bottom -->
        <div class="footer-bottom">
            <div class="footer-bottom-content">
                <div class="copyright">
                    <p>&copy; <?php echo date('Y'); ?> SmarterBettor. All rights reserved.</p>
                </div>
                <div class="disclaimer-badge">
                    <span>21+ Only. Gamble Responsibly.</span>
                </div>
            </div>
        </div>
    </div>
</footer>
<?php wp_footer(); ?>
</body>

</html>