<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <script type='text/javascript' src='https://members.sportshub.com/api/js/hottestStreaks.js?v=1719257845'></script>
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
    <header class="site-header backdrop-blur">
        <nav class="site-nav">
            <!-- Logo -->
            <div class="logo">
                <?php if (has_custom_logo()) {
                    the_custom_logo();
                } else { ?>
                    <span class="site-title"><a href="<?php echo esc_url(home_url('/')); ?>"><?php bloginfo('name'); ?></a></span>
                <?php } ?>
            </div>
            
            <!-- Mobile Menu Toggle -->
            <button class="mobile-menu-toggle" aria-label="Toggle mobile menu" aria-expanded="false">
                <span class="hamburger-line"></span>
                <span class="hamburger-line"></span>
                <span class="hamburger-line"></span>
            </button>
            
            <!-- Navbar -->
            <div class="navbar-wrapper">
                <?php
                    wp_nav_menu([
                        'theme_location' => 'main_menu',
                        'menu_class'     => 'main-menu',
                        'container'      => false,
                        'walker'         => new Custom_Menu_Walker(),
                    ]);
                ?>
            </div>
                 
            <!-- CTA and login -->
            <div class="cta-login">
            <?php
                    wp_nav_menu([
                        'theme_location' => 'secondary_menu',
                        'menu_class'     => 'secondary-menu',
                        'container'      => false,
                        'walker'         => new Custom_Menu_Walker(),
                    ]);
                ?>
            </div>
            
            <!-- Mobile Navigation -->
            <div class="mobile-nav" id="mobile-nav">
                <div class="mobile-nav-content">
                    <div class="mobile-menu-section flex justify-center items-center">
                        <?php if (has_custom_logo()) {
                            the_custom_logo();
                        } else { ?>
                            <span class="site-title"><a href="<?php echo esc_url(home_url('/')); ?>"><?php bloginfo('name'); ?></a></span>
                        <?php } ?>
                    </div>
                    <!-- Main Menu Mobile -->
                    <div class="mobile-menu-section">
                        <?php
                            wp_nav_menu([
                                'theme_location' => 'main_menu',
                                'menu_class'     => 'mobile-main-menu',
                                'container'      => false,
                                'walker'         => new Custom_Menu_Walker(),
                            ]);
                        ?>
                    </div>
                    
                    <!-- Secondary Menu Mobile -->
                    <div class="mobile-menu-section cta-login-mobile">
                        <?php
                            wp_nav_menu([
                                'theme_location' => 'secondary_menu',
                                'menu_class'     => 'mobile-secondary-menu',
                                'container'      => false,
                                'walker'         => new Custom_Menu_Walker(),
                            ]);
                        ?>
                    </div>
                </div>
            </div>
        </nav>
        <div class="header-banner">
            <div class="results">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M20 13c0 5-3.5 7.5-7.66 8.95a1 1 0 0 1-.67-.01C7.5 20.5 4 18 4 13V6a1 1 0 0 1 1-1c2 0 4.5-1.2 6.24-2.72a1.17 1.17 0 0 1 1.52 0C14.51 3.81 17 5 19 5a1 1 0 0 1 1 1z"></path></svg>
                <span>Verified Results</span>
            </div>
            <div class="members">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2"></path><circle cx="9" cy="7" r="4"></circle><path d="M22 21v-2a4 4 0 0 0-3-3.87"></path><path d="M16 3.13a4 4 0 0 1 0 7.75"></path></svg>
                <span>10,000+ Active Members</span>
            </div>
            <div class="win-rate">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><polyline points="22 7 13.5 15.5 8.5 10.5 2 17"></polyline><polyline points="16 7 22 7 22 13"></polyline></svg>
                <span>68% Win Rate (30 Days)</span>
            </div>
        </div>
    </header>

    <script>
    document.addEventListener('DOMContentLoaded', function() {
        const mobileToggle = document.querySelector('.mobile-menu-toggle');
        const mobileNav = document.querySelector('.mobile-nav');
        const body = document.body;
        
        if (mobileToggle && mobileNav) {
            mobileToggle.addEventListener('click', function() {
                const isExpanded = this.getAttribute('aria-expanded') === 'true';
                
                // Toggle aria-expanded
                this.setAttribute('aria-expanded', !isExpanded);
                
                // Toggle mobile nav
                mobileNav.classList.toggle('active');
                
                // Prevent body scroll when menu is open
                if (!isExpanded) {
                    body.style.overflow = 'hidden';
                } else {
                    body.style.overflow = '';
                }
            });
            
            // Close menu when clicking on a link
            const mobileLinks = mobileNav.querySelectorAll('a');
            mobileLinks.forEach(link => {
                link.addEventListener('click', function() {
                    mobileNav.classList.remove('active');
                    mobileToggle.setAttribute('aria-expanded', 'false');
                    body.style.overflow = '';
                });
            });
            
            // Close menu when clicking outside
            mobileNav.addEventListener('click', function(e) {
                if (e.target === mobileNav) {
                    mobileNav.classList.remove('active');
                    mobileToggle.setAttribute('aria-expanded', 'false');
                    body.style.overflow = '';
                }
            });
            
            // Close menu on escape key
            document.addEventListener('keydown', function(e) {
                if (e.key === 'Escape' && mobileNav.classList.contains('active')) {
                    mobileNav.classList.remove('active');
                    mobileToggle.setAttribute('aria-expanded', 'false');
                    body.style.overflow = '';
                }
            });
            
            // Handle window resize
            window.addEventListener('resize', function() {
                if (window.innerWidth > 1024) {
                    mobileNav.classList.remove('active');
                    mobileToggle.setAttribute('aria-expanded', 'false');
                    body.style.overflow = '';
                }
            });
        }
    });
    </script>
