<?php get_header(); ?>

<?php $show_sidebar = get_field('show_sidebar'); ?>

<main class="site-main">
    <div class="main-content-wrapper">
        <div class="content" id="primary">
        <?php
        if ( have_posts() ) :
            while ( have_posts() ) : the_post(); ?>

                <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                    <?php if ( has_post_thumbnail() ) : ?>
                        <div class="post-thumbnail">
                            <?php the_post_thumbnail( 'full' ); ?>
                        </div>
                    <?php endif; ?>

                    <?php if (!shn_should_hide_title()): ?>
                    <header class="entry-header">
                        <h1 class="entry-title"><?php the_title(); ?></h1>
                        <div class="entry-meta">
                            <span class="post-author"><?php the_author_posts_link(); ?></span> in 
                            <span class="post-category"><?php the_category( ', ' ); ?></span>
                        </div>
                    </header>
                    <?php endif; ?>

                    <div class="entry-content">
                        <?php the_content(); ?>
                    </div>
                </article>

            <?php endwhile;
        else :
            echo '<p>There is no content to show.</p>';
        endif;
        ?>
    </div>

    <?php if ( $show_sidebar ) : ?>
        <?php get_sidebar(); ?>
    <?php endif; ?>
    </div>
</main>

<?php get_footer(); ?>
