<?php
require_once get_stylesheet_directory() . '/custom-walker.php';

// Enqueue parent and child theme styles
function shn_base_child_enqueue_styles() {
    wp_enqueue_style( 'shn-base-parent-style', get_template_directory_uri() . '/style.css' );

    wp_enqueue_style(
        'shn-base-child-main-style',
        get_stylesheet_uri(), 
        array('shn-base-parent-style'),
        wp_get_theme()->get('Version') 
    );

    wp_enqueue_style(
        'shn-base-header-style',
        get_stylesheet_directory_uri() . '/css/style-header.css',
        array('shn-base-child-main-style'),
        wp_get_theme()->get('Version')
    );

    wp_enqueue_style(
        'shn-base-footer-style',
        get_stylesheet_directory_uri() . '/css/style-footer.css',
        array('shn-base-header-style'),
        wp_get_theme()->get('Version')
    );

    wp_enqueue_style(
        'shn-base-single-style',
        get_stylesheet_directory_uri() . '/css/style-single.css',
        array('shn-base-header-style'),
        wp_get_theme()->get('Version')
    );

    wp_enqueue_style(
        'shn-base-front-style',
        get_stylesheet_directory_uri() . '/css/style-front.css',
        array('shn-base-header-style'),
        wp_get_theme()->get('Version')
    );
}

add_action( 'wp_enqueue_scripts', 'shn_base_child_enqueue_styles' );

// Register the header menu 
function shn_child_register_menus() {
    register_nav_menus([
        'main_menu' => __('Navbar', 'shn-base-child'),
        'secondary_menu' => __('Secondary Menu', 'shn-base-child'),
        'platform_menu' => __('Platform Menu', 'shn-base-child'),
        'support_menu' => __('Support Menu', 'shn-base-child'),
        'legal_menu' => __('Legal Menu', 'shn-base-child'),
    ]);
}
add_action('after_setup_theme', 'shn_child_register_menus');

// Register footer widget areas
function shn_child_register_footer_widgets() {
    register_sidebar([
        'name' => __('Footer Widget 1', 'shn-base-child'),
        'id' => 'footer-widget-1',
        'description' => __('First footer widget area', 'shn-base-child'),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3 class="widget-title">',
        'after_title' => '</h3>',
    ]);

    register_sidebar([
        'name' => __('Footer Widget 2', 'shn-base-child'),
        'id' => 'footer-widget-2',
        'description' => __('Second footer widget area', 'shn-base-child'),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3 class="widget-title">',
        'after_title' => '</h3>',
    ]);

    register_sidebar([
        'name' => __('Footer Widget 3', 'shn-base-child'),
        'id' => 'footer-widget-3',
        'description' => __('Third footer widget area', 'shn-base-child'),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3 class="widget-title">',
        'after_title' => '</h3>',
    ]);

    register_sidebar([
        'name' => __('Footer Widget 4', 'shn-base-child'),
        'id' => 'footer-widget-4',
        'description' => __('Fourth footer widget area', 'shn-base-child'),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3 class="widget-title">',
        'after_title' => '</h3>',
    ]);
}
add_action('widgets_init', 'shn_child_register_footer_widgets');

