<?php
require_once get_stylesheet_directory() . '/custom-walker.php';

// Enqueue parent and child theme styles
function shn_base_child_enqueue_styles() {
    wp_enqueue_style( 'shn-base-parent-style', get_template_directory_uri() . '/style.css' );

    wp_enqueue_style(
        'shn-base-child-main-style',
        get_stylesheet_uri(), 
        array('shn-base-parent-style'),
        wp_get_theme()->get('Version') 
    );

    wp_enqueue_style(
        'shn-base-header-style',
        get_stylesheet_directory_uri() . '/css/style-header.css',
        array('shn-base-child-main-style'),
        wp_get_theme()->get('Version')
    );

    wp_enqueue_style(
        'shn-base-footer-style',
        get_stylesheet_directory_uri() . '/css/style-footer.css',
        array('shn-base-header-style'),
        wp_get_theme()->get('Version')
    );

    wp_enqueue_style(
        'shn-base-single-style',
        get_stylesheet_directory_uri() . '/css/style-single.css',
        array('shn-base-header-style'),
        wp_get_theme()->get('Version')
    );

    wp_enqueue_style(
        'shn-base-front-style',
        get_stylesheet_directory_uri() . '/css/style-front.css',
        array('shn-base-header-style'),
        wp_get_theme()->get('Version')
    );

    wp_enqueue_style(
        'shn-base-page-options-style',
        get_stylesheet_directory_uri() . '/css/style-page-options.css',
        array('shn-base-child-main-style'),
        wp_get_theme()->get('Version')
    );
}

add_action( 'wp_enqueue_scripts', 'shn_base_child_enqueue_styles' );

// Register the header menu 
function shn_child_register_menus() {
    register_nav_menus([
        'main_menu' => __('Navbar', 'shn-base-child'),
        'secondary_menu' => __('Secondary Menu', 'shn-base-child'),
        'platform_menu' => __('Platform Menu', 'shn-base-child'),
        'support_menu' => __('Support Menu', 'shn-base-child'),
        'legal_menu' => __('Legal Menu', 'shn-base-child'),
    ]);
}
add_action('after_setup_theme', 'shn_child_register_menus');

// Register footer widget areas
function shn_child_register_footer_widgets() {
    register_sidebar([
        'name' => __('Footer Widget 1', 'shn-base-child'),
        'id' => 'footer-widget-1',
        'description' => __('First footer widget area', 'shn-base-child'),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3 class="widget-title">',
        'after_title' => '</h3>',
    ]);

    register_sidebar([
        'name' => __('Footer Widget 2', 'shn-base-child'),
        'id' => 'footer-widget-2',
        'description' => __('Second footer widget area', 'shn-base-child'),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3 class="widget-title">',
        'after_title' => '</h3>',
    ]);

    register_sidebar([
        'name' => __('Footer Widget 3', 'shn-base-child'),
        'id' => 'footer-widget-3',
        'description' => __('Third footer widget area', 'shn-base-child'),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3 class="widget-title">',
        'after_title' => '</h3>',
    ]);

    register_sidebar([
        'name' => __('Footer Widget 4', 'shn-base-child'),
        'id' => 'footer-widget-4',
        'description' => __('Fourth footer widget area', 'shn-base-child'),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3 class="widget-title">',
        'after_title' => '</h3>',
    ]);
}
add_action('widgets_init', 'shn_child_register_footer_widgets');

// Add custom metabox for page options
function shn_add_page_options_metabox() {
    add_meta_box(
        'shn_page_options',
        __('Page Display Options', 'shn-base-child'),
        'shn_page_options_callback',
        array('page', 'post'),
        'side',
        'default'
    );
}
add_action('add_meta_boxes', 'shn_add_page_options_metabox');

// Metabox callback function
function shn_page_options_callback($post) {
    wp_nonce_field('shn_page_options_nonce', 'shn_page_options_nonce');
    
    $hide_header = get_post_meta($post->ID, '_shn_hide_header', true);
    $hide_title = get_post_meta($post->ID, '_shn_hide_title', true);
    ?>
    <p>
        <label for="shn_hide_header">
            <input type="checkbox" id="shn_hide_header" name="shn_hide_header" value="1" <?php checked($hide_header, '1'); ?>>
            <?php _e('Hide Header', 'shn-base-child'); ?>
        </label>
    </p>
    <p>
        <label for="shn_hide_title">
            <input type="checkbox" id="shn_hide_title" name="shn_hide_title" value="1" <?php checked($hide_title, '1'); ?>>
            <?php _e('Hide Page Title', 'shn-base-child'); ?>
        </label>
    </p>
    <p class="description">
        <?php _e('Use these options to customize the display of this page.', 'shn-base-child'); ?>
    </p>
    <?php
}

// Save metabox data
function shn_save_page_options($post_id) {
    if (!isset($_POST['shn_page_options_nonce']) || !wp_verify_nonce($_POST['shn_page_options_nonce'], 'shn_page_options_nonce')) {
        return;
    }

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }

    if (!current_user_can('edit_post', $post_id)) {
        return;
    }

    $hide_header = isset($_POST['shn_hide_header']) ? '1' : '0';
    $hide_title = isset($_POST['shn_hide_title']) ? '1' : '0';

    update_post_meta($post_id, '_shn_hide_header', $hide_header);
    update_post_meta($post_id, '_shn_hide_title', $hide_title);
}
add_action('save_post', 'shn_save_page_options');

// Helper functions to check page options
function shn_should_hide_header() {
    global $post;
    if (!$post) return false;
    return get_post_meta($post->ID, '_shn_hide_header', true) === '1';
}

function shn_should_hide_title() {
    global $post;
    if (!$post) return false;
    return get_post_meta($post->ID, '_shn_hide_title', true) === '1';
}

