<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
    <header class="site-header">
        <nav class="site-nav">
            <div class="logo">
                <?php if (has_custom_logo()) {
                    the_custom_logo();
                } else { ?>
                    <span class="site-title"><a href="<?php echo esc_url(home_url('/')); ?>"><?php bloginfo('name'); ?></a></span>
                <?php } ?>
            </div>
            
            <div class="navbar-wrapper">
                <div class="menu-toggle" id="menuToggle" aria-label="Toggle menu">
                    Menu ☰
                </div>
                <div class="navbar-mobile-container" id="navbarMobileContainer"> 
                    <?php
                        wp_nav_menu([
                            'theme_location' => 'main_menu',
                            'menu_class'     => 'main-menu',
                            'container'      => false,
                            'walker'         => new Custom_Menu_Walker(),
                        ]);
                    ?>
                </div>
                <button id="openSearchModal" class="search-button">
                    <svg viewBox="0 0 512 512" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="1em" height="1em"><path fill-rule="evenodd" clip-rule="evenodd" d="M208 48c-88.366 0-160 71.634-160 160s71.634 160 160 160 160-71.634 160-160S296.366 48 208 48zM0 208C0 93.125 93.125 0 208 0s208 93.125 208 208c0 48.741-16.765 93.566-44.843 129.024l133.826 134.018c9.366 9.379 9.355 24.575-.025 33.941-9.379 9.366-24.575 9.355-33.941-.025L337.238 370.987C301.747 399.167 256.839 416 208 416 93.125 416 0 322.875 0 208z"></path></svg>
                </button> 
            </div>
                 
            <!-- Search Modal -->
            <div id="searchModal" class="search-modal">
                <div class="search-modal-content">
                    <div class="close-modal"></div>
                    <?php get_search_form(); ?>
                </div>
            </div>

        </nav>
    </header>
    <script>
    document.addEventListener('DOMContentLoaded', function () {
    const modal = document.getElementById("searchModal");
    const openBtn = document.getElementById("openSearchModal");
    const closeBtn = document.querySelector(".close-modal");

    openBtn.addEventListener("click", () => {
        modal.style.display = "block";
    });

    closeBtn.addEventListener("click", () => {
        modal.style.display = "none";
    });

    window.addEventListener("click", (e) => {
        if (e.target === modal) {
        modal.style.display = "none";
        }
    });
    });

    document.addEventListener('DOMContentLoaded', function () {
        const toggleBtn = document.getElementById('menuToggle');
        const navbar = document.getElementById('navbarMobileContainer');

        toggleBtn.addEventListener('click', function () {
            navbar.classList.toggle('active');
        });
    });
    </script>
